/*
 * Decompiled with CFR 0.152.
 */
package com.tristankechlo.livingthings.entity;

import com.google.common.collect.ImmutableList;
import com.tristankechlo.livingthings.config.entity.CrabConfig;
import com.tristankechlo.livingthings.entity.ai.BetterMeleeAttackGoal;
import com.tristankechlo.livingthings.entity.misc.IMobVariants;
import com.tristankechlo.livingthings.entity.misc.IScaleableMob;
import com.tristankechlo.livingthings.init.ModEntityTypes;
import com.tristankechlo.livingthings.util.ILexiconEntry;
import com.tristankechlo.livingthings.util.LexiconEntries;
import com.tristankechlo.livingthings.util.LivingThingsTags;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;

public class CrabEntity
extends Animal
implements IMobVariants,
NeutralMob,
IScaleableMob,
ILexiconEntry {
    private static final EntityDataAccessor<Byte> CRAB_VARIANT = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Byte> CRAB_SCALING = SynchedEntityData.m_135353_(CrabEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final UniformInt rangedInteger = TimeUtil.m_145020_((int)20, (int)39);
    private int angerTime;
    private UUID angerTarget;

    public CrabEntity(EntityType<? extends CrabEntity> type, Level worldIn) {
        super(type, worldIn);
        this.m_274367_(1.0f);
        this.m_21441_(BlockPathTypes.WATER, 1.0f);
    }

    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        CrabEntity entityChild = (CrabEntity)ModEntityTypes.CRAB.get().m_20615_(this.m_9236_());
        entityChild.setVariant(this.getVariantFromParents((AgeableMob)this, entity));
        entityChild.setScaling(CrabEntity.getWeightedRandomScaling(this.f_19796_));
        double health = CrabConfig.health();
        if (health > 0.0) {
            entityChild.m_21051_(Attributes.f_22276_).m_22100_(health + (double)entityChild.getScaling());
            entityChild.m_21153_(entityChild.m_21233_());
        }
        return entityChild;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, CrabConfig.health()).m_22268_(Attributes.f_22279_, CrabConfig.movementSpeed()).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22281_, CrabConfig.attackDamage());
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new BetterMeleeAttackGoal((PathfinderMob)this, 1.05, false, CrabConfig::canAttack));
        this.f_21345_.m_25352_(1, (Goal)new BreedGoal((Animal)this, 1.1));
        this.f_21345_.m_25352_(1, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(2, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
    }

    public static boolean checkCrabSpawnRules(EntityType<CrabEntity> animal, LevelAccessor world, MobSpawnType reason, BlockPos pos, RandomSource random) {
        return world.m_46801_(pos) || world.m_8055_(pos.m_7495_()).m_204336_(LivingThingsTags.CRAB_SPAWNABLE_ON) && CrabEntity.m_186209_((BlockAndTintGetter)world, (BlockPos)pos);
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, SpawnGroupData spawnDataIn, CompoundTag dataTag) {
        int colorRedWeight = (Integer)CrabConfig.get().colorRedWeight.get();
        int colorWhiteWeight = (Integer)CrabConfig.get().colorWhiteWeight.get();
        int colorBlueWeight = (Integer)CrabConfig.get().colorBlueWeight.get();
        byte variant = this.getRandomVariant(this.f_19796_, new byte[]{0, 1, 2}, new int[]{colorRedWeight, colorWhiteWeight, colorBlueWeight});
        this.setVariant(variant);
        this.setScaling(CrabEntity.getWeightedRandomScaling(this.f_19796_));
        double health = CrabConfig.health();
        if (health > 0.0) {
            this.m_21051_(Attributes.f_22276_).m_22100_(health + (double)this.getScaling());
            this.m_21153_(this.m_21233_());
        }
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public static byte getWeightedRandomScaling(RandomSource random) {
        int scaling1Weight = (Integer)CrabConfig.get().scalingNormalWeight.get();
        int scaling2Weight = (Integer)CrabConfig.get().scalingLargeWeight.get();
        int scaling3Weight = (Integer)CrabConfig.get().scalingSmallWeight.get();
        int scaling4Weight = (Integer)CrabConfig.get().scalingExtraLargeWeight.get();
        if (scaling1Weight <= 0 && scaling2Weight <= 0 && scaling3Weight <= 0 && scaling4Weight <= 0) {
            return 0;
        }
        Optional scaling = WeightedRandom.m_216822_((RandomSource)random, (List)ImmutableList.of((Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling1Weight), 0), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling2Weight), 2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling3Weight), -2), (Object)new IScaleableMob.WeightedMobScaling(Math.max(0, scaling4Weight), 6)));
        return ((IScaleableMob.WeightedMobScaling)scaling.get()).scaling;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CRAB_VARIANT, (Object)0);
        this.f_19804_.m_135372_(CRAB_SCALING, (Object)0);
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128344_("CrabVariant", this.getVariant());
        compound.m_128344_("CrabScaling", this.getScaling());
        this.m_21678_(compound);
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setVariant(compound.m_128445_("CrabVariant"));
        this.setScaling(compound.m_128445_("CrabScaling"));
        this.m_147285_(this.m_9236_(), compound);
    }

    public boolean m_6898_(ItemStack stack) {
        return stack.m_204117_(LivingThingsTags.CRAB_FOOD);
    }

    public int m_5792_() {
        return CrabConfig.maxSpawnedInChunk();
    }

    protected float m_6431_(Pose pose, EntityDimensions size) {
        return size.f_20378_ * 0.9f;
    }

    public boolean m_6040_() {
        return true;
    }

    protected float m_6108_() {
        return 0.98f;
    }

    @Override
    public byte getVariant() {
        return (Byte)this.f_19804_.m_135370_(CRAB_VARIANT);
    }

    @Override
    public void setVariant(byte variant) {
        this.f_19804_.m_135381_(CRAB_VARIANT, (Object)variant);
    }

    @Override
    public byte getScaling() {
        return (Byte)this.f_19804_.m_135370_(CRAB_SCALING);
    }

    @Override
    public void setScaling(byte scaling) {
        this.f_19804_.m_135381_(CRAB_SCALING, (Object)scaling);
        this.m_20090_();
        this.m_6210_();
        this.f_21364_ = Math.abs(scaling) * this.f_19796_.m_188503_(2);
    }

    public void m_7350_(EntityDataAccessor<?> key) {
        if (CRAB_SCALING.equals(key)) {
            this.m_6210_();
        }
        super.m_7350_(key);
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    public EntityDimensions m_6972_(Pose pose) {
        if (this.m_6162_()) {
            return super.m_6972_(pose);
        }
        return super.m_6972_(pose).m_20388_(0.85f + 0.1f * (float)this.getScaling());
    }

    public int m_6784_() {
        return this.angerTime;
    }

    public void m_7870_(int time) {
        this.angerTime = time;
    }

    public UUID m_6120_() {
        return this.angerTarget;
    }

    public void m_6925_(UUID target) {
        this.angerTarget = target;
    }

    public void m_6825_() {
        this.m_7870_(rangedInteger.m_214085_(this.f_19796_));
    }

    @Override
    public ResourceLocation getLexiconEntry() {
        return LexiconEntries.CRAB;
    }
}

